package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait ArtifactType {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.ArtifactType
}
object ArtifactType {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.ArtifactType
  ): zio.aws.devicefarm.model.ArtifactType = value match {
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.SCREENSHOT =>
      val r = SCREENSHOT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.DEVICE_LOG =>
      val r = DEVICE_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.MESSAGE_LOG =>
      val r = MESSAGE_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.VIDEO_LOG =>
      val r = VIDEO_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.RESULT_LOG =>
      val r = RESULT_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.SERVICE_LOG =>
      val r = SERVICE_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.WEBKIT_LOG =>
      val r = WEBKIT_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.INSTRUMENTATION_OUTPUT =>
      val r = INSTRUMENTATION_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.EXERCISER_MONKEY_OUTPUT =>
      val r = EXERCISER_MONKEY_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_JSON_OUTPUT =>
      val r = CALABASH_JSON_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_PRETTY_OUTPUT =>
      val r = CALABASH_PRETTY_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_STANDARD_OUTPUT =>
      val r = CALABASH_STANDARD_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_JAVA_XML_OUTPUT =>
      val r = CALABASH_JAVA_XML_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.AUTOMATION_OUTPUT =>
      val r = AUTOMATION_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_SERVER_OUTPUT =>
      val r = APPIUM_SERVER_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_JAVA_OUTPUT =>
      val r = APPIUM_JAVA_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_JAVA_XML_OUTPUT =>
      val r = APPIUM_JAVA_XML_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_PYTHON_OUTPUT =>
      val r = APPIUM_PYTHON_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_PYTHON_XML_OUTPUT =>
      val r = APPIUM_PYTHON_XML_OUTPUT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.EXPLORER_EVENT_LOG =>
      val r = EXPLORER_EVENT_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.EXPLORER_SUMMARY_LOG =>
      val r = EXPLORER_SUMMARY_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPLICATION_CRASH_REPORT =>
      val r = APPLICATION_CRASH_REPORT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.XCTEST_LOG =>
      val r = XCTEST_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.VIDEO =>
      val r = VIDEO
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.CUSTOMER_ARTIFACT =>
      val r = CUSTOMER_ARTIFACT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.CUSTOMER_ARTIFACT_LOG =>
      val r = CUSTOMER_ARTIFACT_LOG
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactType.TESTSPEC_OUTPUT =>
      val r = TESTSPEC_OUTPUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.UNKNOWN_TO_SDK_VERSION
  }
  case object UNKNOWN extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.UNKNOWN
  }
  case object SCREENSHOT extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.SCREENSHOT
  }
  case object DEVICE_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.DEVICE_LOG
  }
  case object MESSAGE_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.MESSAGE_LOG
  }
  case object VIDEO_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.VIDEO_LOG
  }
  case object RESULT_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.RESULT_LOG
  }
  case object SERVICE_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.SERVICE_LOG
  }
  case object WEBKIT_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.WEBKIT_LOG
  }
  case object INSTRUMENTATION_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.INSTRUMENTATION_OUTPUT
  }
  case object EXERCISER_MONKEY_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.EXERCISER_MONKEY_OUTPUT
  }
  case object CALABASH_JSON_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_JSON_OUTPUT
  }
  case object CALABASH_PRETTY_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_PRETTY_OUTPUT
  }
  case object CALABASH_STANDARD_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_STANDARD_OUTPUT
  }
  case object CALABASH_JAVA_XML_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.CALABASH_JAVA_XML_OUTPUT
  }
  case object AUTOMATION_OUTPUT extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.AUTOMATION_OUTPUT
  }
  case object APPIUM_SERVER_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_SERVER_OUTPUT
  }
  case object APPIUM_JAVA_OUTPUT extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_JAVA_OUTPUT
  }
  case object APPIUM_JAVA_XML_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_JAVA_XML_OUTPUT
  }
  case object APPIUM_PYTHON_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_PYTHON_OUTPUT
  }
  case object APPIUM_PYTHON_XML_OUTPUT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPIUM_PYTHON_XML_OUTPUT
  }
  case object EXPLORER_EVENT_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.EXPLORER_EVENT_LOG
  }
  case object EXPLORER_SUMMARY_LOG
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.EXPLORER_SUMMARY_LOG
  }
  case object APPLICATION_CRASH_REPORT
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.APPLICATION_CRASH_REPORT
  }
  case object XCTEST_LOG extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.XCTEST_LOG
  }
  case object VIDEO extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.VIDEO
  }
  case object CUSTOMER_ARTIFACT extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.CUSTOMER_ARTIFACT
  }
  case object CUSTOMER_ARTIFACT_LOG
      extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.CUSTOMER_ARTIFACT_LOG
  }
  case object TESTSPEC_OUTPUT extends zio.aws.devicefarm.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactType =
      software.amazon.awssdk.services.devicefarm.model.ArtifactType.TESTSPEC_OUTPUT
  }
}
