package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CPU(
    frequency: Optional[String] = Optional.Absent,
    architecture: Optional[String] = Optional.Absent,
    clock: Optional[Double] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.CPU = {
    import CPU.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CPU
      .builder()
      .optionallyWith(frequency.map(value => value: java.lang.String))(
        _.frequency
      )
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(clock.map(value => value: java.lang.Double))(_.clock)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CPU.ReadOnly =
    zio.aws.devicefarm.model.CPU.wrap(buildAwsValue())
}
object CPU {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.CPU] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CPU = zio.aws.devicefarm.model.CPU(
      frequency.map(value => value),
      architecture.map(value => value),
      clock.map(value => value)
    )
    def frequency: Optional[String]
    def architecture: Optional[String]
    def clock: Optional[Double]
    def getFrequency: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getClock: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("clock", clock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CPU
  ) extends zio.aws.devicefarm.model.CPU.ReadOnly {
    override val frequency: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.frequency())
      .map(value => value: String)
    override val architecture: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => value: String)
    override val clock: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.clock())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CPU
  ): zio.aws.devicefarm.model.CPU.ReadOnly = new Wrapper(impl)
}
