package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateInstanceProfileResponse(
    instanceProfile: Optional[zio.aws.devicefarm.model.InstanceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse = {
    import CreateInstanceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
      .builder()
      .optionallyWith(instanceProfile.map(value => value.buildAwsValue()))(
        _.instanceProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateInstanceProfileResponse.wrap(buildAwsValue())
}
object CreateInstanceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateInstanceProfileResponse =
      zio.aws.devicefarm.model.CreateInstanceProfileResponse(
        instanceProfile.map(value => value.asEditable)
      )
    def instanceProfile
        : Optional[zio.aws.devicefarm.model.InstanceProfile.ReadOnly]
    def getInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.InstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("instanceProfile", instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
  ) extends zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly {
    override val instanceProfile
        : Optional[zio.aws.devicefarm.model.InstanceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfile())
        .map(value => zio.aws.devicefarm.model.InstanceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse
  ): zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
