package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNetworkProfileResponse(
    networkProfile: Optional[zio.aws.devicefarm.model.NetworkProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse = {
    import CreateNetworkProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse
      .builder()
      .optionallyWith(networkProfile.map(value => value.buildAwsValue()))(
        _.networkProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateNetworkProfileResponse.wrap(buildAwsValue())
}
object CreateNetworkProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateNetworkProfileResponse =
      zio.aws.devicefarm.model.CreateNetworkProfileResponse(
        networkProfile.map(value => value.asEditable)
      )
    def networkProfile
        : Optional[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]
    def getNetworkProfile
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      AwsError.unwrapOptionField("networkProfile", networkProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse
  ) extends zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly {
    override val networkProfile
        : Optional[zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProfile())
        .map(value => zio.aws.devicefarm.model.NetworkProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse
  ): zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly =
    new Wrapper(impl)
}
