package zio.aws.devicefarm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{JobTimeoutMinutes, Name}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateProjectRequest(
    name: Name,
    defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        defaultJobTimeoutMinutes.map(value =>
          JobTimeoutMinutes.unwrap(value): Integer
        )
      )(_.defaultJobTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateProjectRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateProjectRequest =
      zio.aws.devicefarm.model.CreateProjectRequest(
        name,
        defaultJobTimeoutMinutes.map(value => value)
      )
    def name: Name
    def defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDefaultJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField(
        "defaultJobTimeoutMinutes",
        defaultJobTimeoutMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest
  ) extends zio.aws.devicefarm.model.CreateProjectRequest.ReadOnly {
    override val name: Name =
      zio.aws.devicefarm.model.primitives.Name(impl.name())
    override val defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultJobTimeoutMinutes())
        .map(value =>
          zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest
  ): zio.aws.devicefarm.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
