package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateProjectResponse(
    project: Optional[zio.aws.devicefarm.model.Project] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse
      .builder()
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateProjectResponse =
      zio.aws.devicefarm.model
        .CreateProjectResponse(project.map(value => value.asEditable))
    def project: Optional[zio.aws.devicefarm.model.Project.ReadOnly]
    def getProject
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Project.ReadOnly] =
      AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse
  ) extends zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly {
    override val project: Optional[zio.aws.devicefarm.model.Project.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.project())
        .map(value => zio.aws.devicefarm.model.Project.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse
  ): zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly = new Wrapper(impl)
}
