package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{DateTime, SensitiveString}
import scala.jdk.CollectionConverters.*
final case class CreateTestGridUrlResponse(
    url: Optional[SensitiveString] = Optional.Absent,
    expires: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse = {
    import CreateTestGridUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
      .builder()
      .optionallyWith(
        url.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(expires.map(value => DateTime.unwrap(value): Instant))(
        _.expires
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateTestGridUrlResponse.wrap(buildAwsValue())
}
object CreateTestGridUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateTestGridUrlResponse =
      zio.aws.devicefarm.model.CreateTestGridUrlResponse(
        url.map(value => value),
        expires.map(value => value)
      )
    def url: Optional[SensitiveString]
    def expires: Optional[DateTime]
    def getUrl: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("url", url)
    def getExpires: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("expires", expires)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
  ) extends zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly {
    override val url: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.devicefarm.model.primitives.SensitiveString(value))
    override val expires: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse
  ): zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
