package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait CurrencyCode {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.CurrencyCode
}
object CurrencyCode {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.CurrencyCode
  ): zio.aws.devicefarm.model.CurrencyCode = value match {
    case software.amazon.awssdk.services.devicefarm.model.CurrencyCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.CurrencyCode.USD =>
      val r = USD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.CurrencyCode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.CurrencyCode =
      software.amazon.awssdk.services.devicefarm.model.CurrencyCode.UNKNOWN_TO_SDK_VERSION
  }
  case object USD extends zio.aws.devicefarm.model.CurrencyCode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.CurrencyCode =
      software.amazon.awssdk.services.devicefarm.model.CurrencyCode.USD
  }
}
