package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeviceFilter(
    attribute: zio.aws.devicefarm.model.DeviceFilterAttribute,
    operator: zio.aws.devicefarm.model.RuleOperator,
    values: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeviceFilter = {
    import DeviceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeviceFilter
      .builder()
      .attribute(attribute.unwrap)
      .operator(operator.unwrap)
      .values(values.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeviceFilter.ReadOnly =
    zio.aws.devicefarm.model.DeviceFilter.wrap(buildAwsValue())
}
object DeviceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeviceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeviceFilter =
      zio.aws.devicefarm.model.DeviceFilter(attribute, operator, values)
    def attribute: zio.aws.devicefarm.model.DeviceFilterAttribute
    def operator: zio.aws.devicefarm.model.RuleOperator
    def values: List[String]
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.devicefarm.model.DeviceFilterAttribute] =
      ZIO.succeed(attribute)
    def getOperator: ZIO[Any, Nothing, zio.aws.devicefarm.model.RuleOperator] =
      ZIO.succeed(operator)
    def getValues: ZIO[Any, Nothing, List[String]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceFilter
  ) extends zio.aws.devicefarm.model.DeviceFilter.ReadOnly {
    override val attribute: zio.aws.devicefarm.model.DeviceFilterAttribute =
      zio.aws.devicefarm.model.DeviceFilterAttribute.wrap(impl.attribute())
    override val operator: zio.aws.devicefarm.model.RuleOperator =
      zio.aws.devicefarm.model.RuleOperator.wrap(impl.operator())
    override val values: List[String] = impl
      .values()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceFilter
  ): zio.aws.devicefarm.model.DeviceFilter.ReadOnly = new Wrapper(impl)
}
