package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceFormFactor {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor
}
object DeviceFormFactor {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor
  ): zio.aws.devicefarm.model.DeviceFormFactor = value match {
    case software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor.PHONE =>
      val r = PHONE
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor.TABLET =>
      val r = TABLET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.DeviceFormFactor {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor =
      software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor.UNKNOWN_TO_SDK_VERSION
  }
  case object PHONE extends zio.aws.devicefarm.model.DeviceFormFactor {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor =
      software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor.PHONE
  }
  case object TABLET extends zio.aws.devicefarm.model.DeviceFormFactor {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor =
      software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor.TABLET
  }
}
