package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeviceMinutes(
    total: Optional[Double] = Optional.Absent,
    metered: Optional[Double] = Optional.Absent,
    unmetered: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeviceMinutes = {
    import DeviceMinutes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeviceMinutes
      .builder()
      .optionallyWith(total.map(value => value: java.lang.Double))(_.total)
      .optionallyWith(metered.map(value => value: java.lang.Double))(_.metered)
      .optionallyWith(unmetered.map(value => value: java.lang.Double))(
        _.unmetered
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeviceMinutes.ReadOnly =
    zio.aws.devicefarm.model.DeviceMinutes.wrap(buildAwsValue())
}
object DeviceMinutes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeviceMinutes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeviceMinutes =
      zio.aws.devicefarm.model.DeviceMinutes(
        total.map(value => value),
        metered.map(value => value),
        unmetered.map(value => value)
      )
    def total: Optional[Double]
    def metered: Optional[Double]
    def unmetered: Optional[Double]
    def getTotal: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("total", total)
    def getMetered: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("metered", metered)
    def getUnmetered: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("unmetered", unmetered)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceMinutes
  ) extends zio.aws.devicefarm.model.DeviceMinutes.ReadOnly {
    override val total: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: Double)
    override val metered: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.metered())
      .map(value => value: Double)
    override val unmetered: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.unmetered())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceMinutes
  ): zio.aws.devicefarm.model.DeviceMinutes.ReadOnly = new Wrapper(impl)
}
