package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  Integer,
  Message,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DevicePool(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Message] = Optional.Absent,
    `type`: Optional[zio.aws.devicefarm.model.DevicePoolType] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.devicefarm.model.Rule]] = Optional.Absent,
    maxDevices: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DevicePool = {
    import DevicePool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DevicePool
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(maxDevices.map(value => value: java.lang.Integer))(
        _.maxDevices
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DevicePool.ReadOnly =
    zio.aws.devicefarm.model.DevicePool.wrap(buildAwsValue())
}
object DevicePool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DevicePool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DevicePool =
      zio.aws.devicefarm.model.DevicePool(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxDevices.map(value => value)
      )
    def arn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def description: Optional[Message]
    def `type`: Optional[zio.aws.devicefarm.model.DevicePoolType]
    def rules: Optional[List[zio.aws.devicefarm.model.Rule.ReadOnly]]
    def maxDevices: Optional[Integer]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePoolType] =
      AwsError.unwrapOptionField("type", `type`)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getMaxDevices: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxDevices", maxDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DevicePool
  ) extends zio.aws.devicefarm.model.DevicePool.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val `type`: Optional[zio.aws.devicefarm.model.DevicePoolType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devicefarm.model.DevicePoolType.wrap(value))
    override val rules: Optional[List[zio.aws.devicefarm.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Rule.wrap(item)
          }.toList
        )
    override val maxDevices: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxDevices())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DevicePool
  ): zio.aws.devicefarm.model.DevicePool.ReadOnly = new Wrapper(impl)
}
