package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeviceSelectionResult(
    filters: Optional[Iterable[zio.aws.devicefarm.model.DeviceFilter]] =
      Optional.Absent,
    matchedDevicesCount: Optional[Integer] = Optional.Absent,
    maxDevices: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult = {
    import DeviceSelectionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        matchedDevicesCount.map(value => value: java.lang.Integer)
      )(_.matchedDevicesCount)
      .optionallyWith(maxDevices.map(value => value: java.lang.Integer))(
        _.maxDevices
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly =
    zio.aws.devicefarm.model.DeviceSelectionResult.wrap(buildAwsValue())
}
object DeviceSelectionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeviceSelectionResult =
      zio.aws.devicefarm.model.DeviceSelectionResult(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        matchedDevicesCount.map(value => value),
        maxDevices.map(value => value)
      )
    def filters: Optional[List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly]]
    def matchedDevicesCount: Optional[Integer]
    def maxDevices: Optional[Integer]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DeviceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMatchedDevicesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("matchedDevicesCount", matchedDevicesCount)
    def getMaxDevices: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxDevices", maxDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
  ) extends zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly {
    override val filters
        : Optional[List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.DeviceFilter.wrap(item)
          }.toList
        )
    override val matchedDevicesCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.matchedDevicesCount())
      .map(value => value: Integer)
    override val maxDevices: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxDevices())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult
  ): zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly = new Wrapper(impl)
}
