package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionResult {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.ExecutionResult
}
object ExecutionResult {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.ExecutionResult
  ): zio.aws.devicefarm.model.ExecutionResult = value match {
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.PASSED =>
      val r = PASSED
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.WARNED =>
      val r = WARNED
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.SKIPPED =>
      val r = SKIPPED
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.ERRORED =>
      val r = ERRORED
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResult.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.PENDING
  }
  case object PASSED extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.PASSED
  }
  case object WARNED extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.WARNED
  }
  case object FAILED extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.FAILED
  }
  case object SKIPPED extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.SKIPPED
  }
  case object ERRORED extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.ERRORED
  }
  case object STOPPED extends zio.aws.devicefarm.model.ExecutionResult {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResult =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResult.STOPPED
  }
}
