package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionResultCode {
  def unwrap
      : software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode
}
object ExecutionResultCode {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode
  ): zio.aws.devicefarm.model.ExecutionResultCode = value match {
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode.PARSING_FAILED =>
      val r = PARSING_FAILED
      r
    case software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode.VPC_ENDPOINT_SETUP_FAILED =>
      val r = VPC_ENDPOINT_SETUP_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.ExecutionResultCode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode.UNKNOWN_TO_SDK_VERSION
  }
  case object PARSING_FAILED
      extends zio.aws.devicefarm.model.ExecutionResultCode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode.PARSING_FAILED
  }
  case object VPC_ENDPOINT_SETUP_FAILED
      extends zio.aws.devicefarm.model.ExecutionResultCode {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode =
      software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode.VPC_ENDPOINT_SETUP_FAILED
  }
}
