package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDevicePoolCompatibilityResponse(
    compatibleDevices: Optional[
      Iterable[zio.aws.devicefarm.model.DevicePoolCompatibilityResult]
    ] = Optional.Absent,
    incompatibleDevices: Optional[
      Iterable[zio.aws.devicefarm.model.DevicePoolCompatibilityResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse = {
    import GetDevicePoolCompatibilityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse
      .builder()
      .optionallyWith(
        compatibleDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compatibleDevices)
      .optionallyWith(
        incompatibleDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.incompatibleDevices)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly =
    zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse
      .wrap(buildAwsValue())
}
object GetDevicePoolCompatibilityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse =
      zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse(
        compatibleDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        incompatibleDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def compatibleDevices: Optional[
      List[zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly]
    ]
    def incompatibleDevices: Optional[
      List[zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly]
    ]
    def getCompatibleDevices: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly
    ]] = AwsError.unwrapOptionField("compatibleDevices", compatibleDevices)
    def getIncompatibleDevices: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly
    ]] = AwsError.unwrapOptionField("incompatibleDevices", incompatibleDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse
  ) extends zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly {
    override val compatibleDevices: Optional[
      List[zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.compatibleDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.DevicePoolCompatibilityResult.wrap(item)
        }.toList
      )
    override val incompatibleDevices: Optional[
      List[zio.aws.devicefarm.model.DevicePoolCompatibilityResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.incompatibleDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.DevicePoolCompatibilityResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse
  ): zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly =
    new Wrapper(impl)
}
