package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetJobResponse(
    job: Optional[zio.aws.devicefarm.model.Job] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetJobResponse = {
    import GetJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetJobResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetJobResponse.ReadOnly =
    zio.aws.devicefarm.model.GetJobResponse.wrap(buildAwsValue())
}
object GetJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetJobResponse =
      zio.aws.devicefarm.model
        .GetJobResponse(job.map(value => value.asEditable))
    def job: Optional[zio.aws.devicefarm.model.Job.ReadOnly]
    def getJob: ZIO[Any, AwsError, zio.aws.devicefarm.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetJobResponse
  ) extends zio.aws.devicefarm.model.GetJobResponse.ReadOnly {
    override val job: Optional[zio.aws.devicefarm.model.Job.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.job())
        .map(value => zio.aws.devicefarm.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetJobResponse
  ): zio.aws.devicefarm.model.GetJobResponse.ReadOnly = new Wrapper(impl)
}
