package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetTestResponse(
    test: Optional[zio.aws.devicefarm.model.Test] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetTestResponse = {
    import GetTestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetTestResponse
      .builder()
      .optionallyWith(test.map(value => value.buildAwsValue()))(_.test)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetTestResponse.ReadOnly =
    zio.aws.devicefarm.model.GetTestResponse.wrap(buildAwsValue())
}
object GetTestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetTestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetTestResponse =
      zio.aws.devicefarm.model
        .GetTestResponse(test.map(value => value.asEditable))
    def test: Optional[zio.aws.devicefarm.model.Test.ReadOnly]
    def getTest: ZIO[Any, AwsError, zio.aws.devicefarm.model.Test.ReadOnly] =
      AwsError.unwrapOptionField("test", test)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestResponse
  ) extends zio.aws.devicefarm.model.GetTestResponse.ReadOnly {
    override val test: Optional[zio.aws.devicefarm.model.Test.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.test())
        .map(value => zio.aws.devicefarm.model.Test.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetTestResponse
  ): zio.aws.devicefarm.model.GetTestResponse.ReadOnly = new Wrapper(impl)
}
