package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetVpceConfigurationRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest = {
    import GetVpceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.GetVpceConfigurationRequest.ReadOnly =
    zio.aws.devicefarm.model.GetVpceConfigurationRequest.wrap(buildAwsValue())
}
object GetVpceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetVpceConfigurationRequest =
      zio.aws.devicefarm.model.GetVpceConfigurationRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest
  ) extends zio.aws.devicefarm.model.GetVpceConfigurationRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest
  ): zio.aws.devicefarm.model.GetVpceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
