package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Message, Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InstanceProfile(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    packageCleanup: Optional[Boolean] = Optional.Absent,
    excludeAppPackagesFromCleanup: Optional[Iterable[String]] = Optional.Absent,
    rebootAfterUse: Optional[Boolean] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.InstanceProfile = {
    import InstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.InstanceProfile
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(packageCleanup.map(value => value: java.lang.Boolean))(
        _.packageCleanup
      )
      .optionallyWith(
        excludeAppPackagesFromCleanup.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAppPackagesFromCleanup)
      .optionallyWith(rebootAfterUse.map(value => value: java.lang.Boolean))(
        _.rebootAfterUse
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.InstanceProfile.ReadOnly =
    zio.aws.devicefarm.model.InstanceProfile.wrap(buildAwsValue())
}
object InstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.InstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.InstanceProfile =
      zio.aws.devicefarm.model.InstanceProfile(
        arn.map(value => value),
        packageCleanup.map(value => value),
        excludeAppPackagesFromCleanup.map(value => value),
        rebootAfterUse.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def arn: Optional[AmazonResourceName]
    def packageCleanup: Optional[Boolean]
    def excludeAppPackagesFromCleanup: Optional[List[String]]
    def rebootAfterUse: Optional[Boolean]
    def name: Optional[Name]
    def description: Optional[Message]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getPackageCleanup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("packageCleanup", packageCleanup)
    def getExcludeAppPackagesFromCleanup: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "excludeAppPackagesFromCleanup",
        excludeAppPackagesFromCleanup
      )
    def getRebootAfterUse: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rebootAfterUse", rebootAfterUse)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.InstanceProfile
  ) extends zio.aws.devicefarm.model.InstanceProfile.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val packageCleanup: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.packageCleanup())
      .map(value => value: Boolean)
    override val excludeAppPackagesFromCleanup: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeAppPackagesFromCleanup())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val rebootAfterUse: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.rebootAfterUse())
      .map(value => value: Boolean)
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.InstanceProfile
  ): zio.aws.devicefarm.model.InstanceProfile.ReadOnly = new Wrapper(impl)
}
