package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDevicePoolsRequest(
    arn: AmazonResourceName,
    `type`: Optional[zio.aws.devicefarm.model.DevicePoolType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest = {
    import ListDevicePoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListDevicePoolsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListDevicePoolsRequest.wrap(buildAwsValue())
}
object ListDevicePoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListDevicePoolsRequest =
      zio.aws.devicefarm.model.ListDevicePoolsRequest(
        arn,
        `type`.map(value => value),
        nextToken.map(value => value)
      )
    def arn: AmazonResourceName
    def `type`: Optional[zio.aws.devicefarm.model.DevicePoolType]
    def nextToken: Optional[PaginationToken]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePoolType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest
  ) extends zio.aws.devicefarm.model.ListDevicePoolsRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val `type`: Optional[zio.aws.devicefarm.model.DevicePoolType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devicefarm.model.DevicePoolType.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest
  ): zio.aws.devicefarm.model.ListDevicePoolsRequest.ReadOnly = new Wrapper(
    impl
  )
}
