package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDevicesRequest(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.devicefarm.model.DeviceFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest = {
    import ListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListDevicesRequest.ReadOnly =
    zio.aws.devicefarm.model.ListDevicesRequest.wrap(buildAwsValue())
}
object ListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListDevicesRequest =
      zio.aws.devicefarm.model.ListDevicesRequest(
        arn.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[AmazonResourceName]
    def nextToken: Optional[PaginationToken]
    def filters: Optional[List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly]]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DeviceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest
  ) extends zio.aws.devicefarm.model.ListDevicesRequest.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
    override val filters
        : Optional[List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.DeviceFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest
  ): zio.aws.devicefarm.model.ListDevicesRequest.ReadOnly = new Wrapper(impl)
}
