package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListInstanceProfilesResponse(
    instanceProfiles: Optional[
      Iterable[zio.aws.devicefarm.model.InstanceProfile]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse = {
    import ListInstanceProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse
      .builder()
      .optionallyWith(
        instanceProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceProfiles)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListInstanceProfilesResponse.wrap(buildAwsValue())
}
object ListInstanceProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListInstanceProfilesResponse =
      zio.aws.devicefarm.model.ListInstanceProfilesResponse(
        instanceProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceProfiles
        : Optional[List[zio.aws.devicefarm.model.InstanceProfile.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getInstanceProfiles: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.InstanceProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceProfiles", instanceProfiles)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse
  ) extends zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly {
    override val instanceProfiles
        : Optional[List[zio.aws.devicefarm.model.InstanceProfile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.InstanceProfile.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse
  ): zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
