package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.DeviceFarmArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceARN: DeviceFarmArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(DeviceFarmArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.devicefarm.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTagsForResourceRequest =
      zio.aws.devicefarm.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: DeviceFarmArn
    def getResourceARN: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest
  ) extends zio.aws.devicefarm.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest
  ): zio.aws.devicefarm.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
