package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTestGridProjectsResponse(
    testGridProjects: Optional[
      Iterable[zio.aws.devicefarm.model.TestGridProject]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse = {
    import ListTestGridProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse
      .builder()
      .optionallyWith(
        testGridProjects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testGridProjects)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridProjectsResponse.wrap(buildAwsValue())
}
object ListTestGridProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTestGridProjectsResponse =
      zio.aws.devicefarm.model.ListTestGridProjectsResponse(
        testGridProjects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def testGridProjects
        : Optional[List[zio.aws.devicefarm.model.TestGridProject.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getTestGridProjects: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.TestGridProject.ReadOnly
    ]] = AwsError.unwrapOptionField("testGridProjects", testGridProjects)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse
  ) extends zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly {
    override val testGridProjects
        : Optional[List[zio.aws.devicefarm.model.TestGridProject.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testGridProjects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.TestGridProject.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse
  ): zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly =
    new Wrapper(impl)
}
