package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTestsResponse(
    tests: Optional[Iterable[zio.aws.devicefarm.model.Test]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestsResponse = {
    import ListTestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
      .builder()
      .optionallyWith(
        tests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tests)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListTestsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListTestsResponse.wrap(buildAwsValue())
}
object ListTestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTestsResponse =
      zio.aws.devicefarm.model.ListTestsResponse(
        tests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tests: Optional[List[zio.aws.devicefarm.model.Test.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getTests
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Test.ReadOnly]] =
      AwsError.unwrapOptionField("tests", tests)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
  ) extends zio.aws.devicefarm.model.ListTestsResponse.ReadOnly {
    override val tests: Optional[List[zio.aws.devicefarm.model.Test.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Test.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestsResponse
  ): zio.aws.devicefarm.model.ListTestsResponse.ReadOnly = new Wrapper(impl)
}
