package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Location(latitude: Double, longitude: Double) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Location = {
    import Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Location
      .builder()
      .latitude(latitude: java.lang.Double)
      .longitude(longitude: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Location.ReadOnly =
    zio.aws.devicefarm.model.Location.wrap(buildAwsValue())
}
object Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Location =
      zio.aws.devicefarm.model.Location(latitude, longitude)
    def latitude: Double
    def longitude: Double
    def getLatitude: ZIO[Any, Nothing, Double] = ZIO.succeed(latitude)
    def getLongitude: ZIO[Any, Nothing, Double] = ZIO.succeed(longitude)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Location
  ) extends zio.aws.devicefarm.model.Location.ReadOnly {
    override val latitude: Double = impl.latitude(): Double
    override val longitude: Double = impl.longitude(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Location
  ): zio.aws.devicefarm.model.Location.ReadOnly = new Wrapper(impl)
}
