package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  HostAddress,
  Message,
  ClientId,
  DateTime,
  SkipAppResign,
  AmazonResourceName,
  Name
}
import scala.jdk.CollectionConverters.*
final case class RemoteAccessSession(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    created: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.devicefarm.model.ExecutionStatus] =
      Optional.Absent,
    result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    started: Optional[DateTime] = Optional.Absent,
    stopped: Optional[DateTime] = Optional.Absent,
    device: Optional[zio.aws.devicefarm.model.Device] = Optional.Absent,
    instanceArn: Optional[AmazonResourceName] = Optional.Absent,
    remoteDebugEnabled: Optional[Boolean] = Optional.Absent,
    remoteRecordEnabled: Optional[Boolean] = Optional.Absent,
    remoteRecordAppArn: Optional[AmazonResourceName] = Optional.Absent,
    hostAddress: Optional[HostAddress] = Optional.Absent,
    clientId: Optional[ClientId] = Optional.Absent,
    billingMethod: Optional[zio.aws.devicefarm.model.BillingMethod] =
      Optional.Absent,
    deviceMinutes: Optional[zio.aws.devicefarm.model.DeviceMinutes] =
      Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    deviceUdid: Optional[String] = Optional.Absent,
    interactionMode: Optional[zio.aws.devicefarm.model.InteractionMode] =
      Optional.Absent,
    skipAppResign: Optional[SkipAppResign] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession = {
    import RemoteAccessSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(stopped.map(value => DateTime.unwrap(value): Instant))(
        _.stopped
      )
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .optionallyWith(
        instanceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.instanceArn)
      .optionallyWith(
        remoteDebugEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteDebugEnabled)
      .optionallyWith(
        remoteRecordEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteRecordEnabled)
      .optionallyWith(
        remoteRecordAppArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.remoteRecordAppArn)
      .optionallyWith(
        hostAddress.map(value => HostAddress.unwrap(value): java.lang.String)
      )(_.hostAddress)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(billingMethod.map(value => value.unwrap))(_.billingMethod)
      .optionallyWith(deviceMinutes.map(value => value.buildAwsValue()))(
        _.deviceMinutes
      )
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(deviceUdid.map(value => value: java.lang.String))(
        _.deviceUdid
      )
      .optionallyWith(interactionMode.map(value => value.unwrap))(
        _.interactionMode
      )
      .optionallyWith(
        skipAppResign.map(value =>
          SkipAppResign.unwrap(value): java.lang.Boolean
        )
      )(_.skipAppResign)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly =
    zio.aws.devicefarm.model.RemoteAccessSession.wrap(buildAwsValue())
}
object RemoteAccessSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.RemoteAccessSession =
      zio.aws.devicefarm.model.RemoteAccessSession(
        arn.map(value => value),
        name.map(value => value),
        created.map(value => value),
        status.map(value => value),
        result.map(value => value),
        message.map(value => value),
        started.map(value => value),
        stopped.map(value => value),
        device.map(value => value.asEditable),
        instanceArn.map(value => value),
        remoteDebugEnabled.map(value => value),
        remoteRecordEnabled.map(value => value),
        remoteRecordAppArn.map(value => value),
        hostAddress.map(value => value),
        clientId.map(value => value),
        billingMethod.map(value => value),
        deviceMinutes.map(value => value.asEditable),
        endpoint.map(value => value),
        deviceUdid.map(value => value),
        interactionMode.map(value => value),
        skipAppResign.map(value => value)
      )
    def arn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def created: Optional[DateTime]
    def status: Optional[zio.aws.devicefarm.model.ExecutionStatus]
    def result: Optional[zio.aws.devicefarm.model.ExecutionResult]
    def message: Optional[Message]
    def started: Optional[DateTime]
    def stopped: Optional[DateTime]
    def device: Optional[zio.aws.devicefarm.model.Device.ReadOnly]
    def instanceArn: Optional[AmazonResourceName]
    def remoteDebugEnabled: Optional[Boolean]
    def remoteRecordEnabled: Optional[Boolean]
    def remoteRecordAppArn: Optional[AmazonResourceName]
    def hostAddress: Optional[HostAddress]
    def clientId: Optional[ClientId]
    def billingMethod: Optional[zio.aws.devicefarm.model.BillingMethod]
    def deviceMinutes: Optional[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly]
    def endpoint: Optional[String]
    def deviceUdid: Optional[String]
    def interactionMode: Optional[zio.aws.devicefarm.model.InteractionMode]
    def skipAppResign: Optional[SkipAppResign]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getStopped: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getDevice
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
    def getInstanceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getRemoteDebugEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteDebugEnabled", remoteDebugEnabled)
    def getRemoteRecordEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteRecordEnabled", remoteRecordEnabled)
    def getRemoteRecordAppArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("remoteRecordAppArn", remoteRecordAppArn)
    def getHostAddress: ZIO[Any, AwsError, HostAddress] =
      AwsError.unwrapOptionField("hostAddress", hostAddress)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getBillingMethod
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.BillingMethod] =
      AwsError.unwrapOptionField("billingMethod", billingMethod)
    def getDeviceMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      AwsError.unwrapOptionField("deviceMinutes", deviceMinutes)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getDeviceUdid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceUdid", deviceUdid)
    def getInteractionMode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.InteractionMode] =
      AwsError.unwrapOptionField("interactionMode", interactionMode)
    def getSkipAppResign: ZIO[Any, AwsError, SkipAppResign] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
  ) extends zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val created: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.devicefarm.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devicefarm.model.ExecutionStatus.wrap(value))
    override val result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val started: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val stopped: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val device: Optional[zio.aws.devicefarm.model.Device.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.device())
        .map(value => zio.aws.devicefarm.model.Device.wrap(value))
    override val instanceArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceArn())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
        )
    override val remoteDebugEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteDebugEnabled())
      .map(value => value: Boolean)
    override val remoteRecordEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteRecordEnabled())
      .map(value => value: Boolean)
    override val remoteRecordAppArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteRecordAppArn())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
        )
    override val hostAddress: Optional[HostAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.hostAddress())
      .map(value => zio.aws.devicefarm.model.primitives.HostAddress(value))
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.devicefarm.model.primitives.ClientId(value))
    override val billingMethod
        : Optional[zio.aws.devicefarm.model.BillingMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingMethod())
        .map(value => zio.aws.devicefarm.model.BillingMethod.wrap(value))
    override val deviceMinutes
        : Optional[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceMinutes())
        .map(value => zio.aws.devicefarm.model.DeviceMinutes.wrap(value))
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val deviceUdid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceUdid())
      .map(value => value: String)
    override val interactionMode
        : Optional[zio.aws.devicefarm.model.InteractionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interactionMode())
        .map(value => zio.aws.devicefarm.model.InteractionMode.wrap(value))
    override val skipAppResign: Optional[SkipAppResign] = zio.aws.core.internal
      .optionalFromNullable(impl.skipAppResign())
      .map(value => zio.aws.devicefarm.model.primitives.SkipAppResign(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
  ): zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly = new Wrapper(impl)
}
