package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Resolution(
    width: Optional[Integer] = Optional.Absent,
    height: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Resolution = {
    import Resolution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Resolution
      .builder()
      .optionallyWith(width.map(value => value: java.lang.Integer))(_.width)
      .optionallyWith(height.map(value => value: java.lang.Integer))(_.height)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Resolution.ReadOnly =
    zio.aws.devicefarm.model.Resolution.wrap(buildAwsValue())
}
object Resolution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Resolution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Resolution =
      zio.aws.devicefarm.model
        .Resolution(width.map(value => value), height.map(value => value))
    def width: Optional[Integer]
    def height: Optional[Integer]
    def getWidth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("height", height)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Resolution
  ) extends zio.aws.devicefarm.model.Resolution.ReadOnly {
    override val width: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.width())
      .map(value => value: Integer)
    override val height: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.height())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Resolution
  ): zio.aws.devicefarm.model.Resolution.ReadOnly = new Wrapper(impl)
}
