package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait RuleOperator {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.RuleOperator
}
object RuleOperator {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.RuleOperator
  ): zio.aws.devicefarm.model.RuleOperator = value match {
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.LESS_THAN_OR_EQUALS =>
      val r = LESS_THAN_OR_EQUALS
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.GREATER_THAN_OR_EQUALS =>
      val r = GREATER_THAN_OR_EQUALS
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.IN =>
      val r = IN
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.NOT_IN =>
      val r = NOT_IN
      r
    case software.amazon.awssdk.services.devicefarm.model.RuleOperator.CONTAINS =>
      val r = CONTAINS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.EQUALS
  }
  case object LESS_THAN extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.LESS_THAN
  }
  case object LESS_THAN_OR_EQUALS
      extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.LESS_THAN_OR_EQUALS
  }
  case object GREATER_THAN extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.GREATER_THAN
  }
  case object GREATER_THAN_OR_EQUALS
      extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.GREATER_THAN_OR_EQUALS
  }
  case object IN extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.IN
  }
  case object NOT_IN extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.NOT_IN
  }
  case object CONTAINS extends zio.aws.devicefarm.model.RuleOperator {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.RuleOperator =
      software.amazon.awssdk.services.devicefarm.model.RuleOperator.CONTAINS
  }
}
