package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScheduleRunRequest(
    projectArn: AmazonResourceName,
    appArn: Optional[AmazonResourceName] = Optional.Absent,
    devicePoolArn: Optional[AmazonResourceName] = Optional.Absent,
    deviceSelectionConfiguration: Optional[
      zio.aws.devicefarm.model.DeviceSelectionConfiguration
    ] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    test: zio.aws.devicefarm.model.ScheduleRunTest,
    configuration: Optional[zio.aws.devicefarm.model.ScheduleRunConfiguration] =
      Optional.Absent,
    executionConfiguration: Optional[
      zio.aws.devicefarm.model.ExecutionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest = {
    import ScheduleRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest
      .builder()
      .projectArn(AmazonResourceName.unwrap(projectArn): java.lang.String)
      .optionallyWith(
        appArn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.appArn)
      .optionallyWith(
        devicePoolArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.devicePoolArn)
      .optionallyWith(
        deviceSelectionConfiguration.map(value => value.buildAwsValue())
      )(_.deviceSelectionConfiguration)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .test(test.buildAwsValue())
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        executionConfiguration.map(value => value.buildAwsValue())
      )(_.executionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ScheduleRunRequest.ReadOnly =
    zio.aws.devicefarm.model.ScheduleRunRequest.wrap(buildAwsValue())
}
object ScheduleRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ScheduleRunRequest =
      zio.aws.devicefarm.model.ScheduleRunRequest(
        projectArn,
        appArn.map(value => value),
        devicePoolArn.map(value => value),
        deviceSelectionConfiguration.map(value => value.asEditable),
        name.map(value => value),
        test.asEditable,
        configuration.map(value => value.asEditable),
        executionConfiguration.map(value => value.asEditable)
      )
    def projectArn: AmazonResourceName
    def appArn: Optional[AmazonResourceName]
    def devicePoolArn: Optional[AmazonResourceName]
    def deviceSelectionConfiguration: Optional[
      zio.aws.devicefarm.model.DeviceSelectionConfiguration.ReadOnly
    ]
    def name: Optional[Name]
    def test: zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly
    def configuration
        : Optional[zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly]
    def executionConfiguration
        : Optional[zio.aws.devicefarm.model.ExecutionConfiguration.ReadOnly]
    def getProjectArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(projectArn)
    def getAppArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("appArn", appArn)
    def getDevicePoolArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("devicePoolArn", devicePoolArn)
    def getDeviceSelectionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.DeviceSelectionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deviceSelectionConfiguration",
      deviceSelectionConfiguration
    )
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getTest
        : ZIO[Any, Nothing, zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly] =
      ZIO.succeed(test)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getExecutionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.ExecutionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executionConfiguration",
      executionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest
  ) extends zio.aws.devicefarm.model.ScheduleRunRequest.ReadOnly {
    override val projectArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.projectArn())
    override val appArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.appArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val devicePoolArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devicePoolArn())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
        )
    override val deviceSelectionConfiguration: Optional[
      zio.aws.devicefarm.model.DeviceSelectionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceSelectionConfiguration())
      .map(value =>
        zio.aws.devicefarm.model.DeviceSelectionConfiguration.wrap(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val test: zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly =
      zio.aws.devicefarm.model.ScheduleRunTest.wrap(impl.test())
    override val configuration
        : Optional[zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          zio.aws.devicefarm.model.ScheduleRunConfiguration.wrap(value)
        )
    override val executionConfiguration
        : Optional[zio.aws.devicefarm.model.ExecutionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionConfiguration())
        .map(value =>
          zio.aws.devicefarm.model.ExecutionConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest
  ): zio.aws.devicefarm.model.ScheduleRunRequest.ReadOnly = new Wrapper(impl)
}
