package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait TestGridSessionStatus {
  def unwrap
      : software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus
}
object TestGridSessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus
  ): zio.aws.devicefarm.model.TestGridSessionStatus = value match {
    case software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.CLOSED =>
      val r = CLOSED
      r
    case software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.ERRORED =>
      val r = ERRORED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.TestGridSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus =
      software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.devicefarm.model.TestGridSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus =
      software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.ACTIVE
  }
  case object CLOSED extends zio.aws.devicefarm.model.TestGridSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus =
      software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.CLOSED
  }
  case object ERRORED extends zio.aws.devicefarm.model.TestGridSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus =
      software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus.ERRORED
  }
}
