package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Message
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UniqueProblem(
    message: Optional[Message] = Optional.Absent,
    problems: Optional[Iterable[zio.aws.devicefarm.model.Problem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UniqueProblem = {
    import UniqueProblem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UniqueProblem
      .builder()
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        problems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.problems)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UniqueProblem.ReadOnly =
    zio.aws.devicefarm.model.UniqueProblem.wrap(buildAwsValue())
}
object UniqueProblem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UniqueProblem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UniqueProblem =
      zio.aws.devicefarm.model.UniqueProblem(
        message.map(value => value),
        problems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def message: Optional[Message]
    def problems: Optional[List[zio.aws.devicefarm.model.Problem.ReadOnly]]
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getProblems
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Problem.ReadOnly]] =
      AwsError.unwrapOptionField("problems", problems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UniqueProblem
  ) extends zio.aws.devicefarm.model.UniqueProblem.ReadOnly {
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val problems
        : Optional[List[zio.aws.devicefarm.model.Problem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.problems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Problem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UniqueProblem
  ): zio.aws.devicefarm.model.UniqueProblem.ReadOnly = new Wrapper(impl)
}
