package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  Integer,
  Message,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDevicePoolRequest(
    arn: AmazonResourceName,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Message] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.devicefarm.model.Rule]] = Optional.Absent,
    maxDevices: Optional[Integer] = Optional.Absent,
    clearMaxDevices: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest = {
    import UpdateDevicePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(maxDevices.map(value => value: java.lang.Integer))(
        _.maxDevices
      )
      .optionallyWith(clearMaxDevices.map(value => value: java.lang.Boolean))(
        _.clearMaxDevices
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UpdateDevicePoolRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateDevicePoolRequest.wrap(buildAwsValue())
}
object UpdateDevicePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateDevicePoolRequest =
      zio.aws.devicefarm.model.UpdateDevicePoolRequest(
        arn,
        name.map(value => value),
        description.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxDevices.map(value => value),
        clearMaxDevices.map(value => value)
      )
    def arn: AmazonResourceName
    def name: Optional[Name]
    def description: Optional[Message]
    def rules: Optional[List[zio.aws.devicefarm.model.Rule.ReadOnly]]
    def maxDevices: Optional[Integer]
    def clearMaxDevices: Optional[Boolean]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getMaxDevices: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxDevices", maxDevices)
    def getClearMaxDevices: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("clearMaxDevices", clearMaxDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest
  ) extends zio.aws.devicefarm.model.UpdateDevicePoolRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val rules: Optional[List[zio.aws.devicefarm.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Rule.wrap(item)
          }.toList
        )
    override val maxDevices: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxDevices())
      .map(value => value: Integer)
    override val clearMaxDevices: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.clearMaxDevices())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest
  ): zio.aws.devicefarm.model.UpdateDevicePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
