package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Message, Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateInstanceProfileRequest(
    arn: AmazonResourceName,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Message] = Optional.Absent,
    packageCleanup: Optional[Boolean] = Optional.Absent,
    excludeAppPackagesFromCleanup: Optional[Iterable[String]] = Optional.Absent,
    rebootAfterUse: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest = {
    import UpdateInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(packageCleanup.map(value => value: java.lang.Boolean))(
        _.packageCleanup
      )
      .optionallyWith(
        excludeAppPackagesFromCleanup.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAppPackagesFromCleanup)
      .optionallyWith(rebootAfterUse.map(value => value: java.lang.Boolean))(
        _.rebootAfterUse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateInstanceProfileRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateInstanceProfileRequest.wrap(buildAwsValue())
}
object UpdateInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateInstanceProfileRequest =
      zio.aws.devicefarm.model.UpdateInstanceProfileRequest(
        arn,
        name.map(value => value),
        description.map(value => value),
        packageCleanup.map(value => value),
        excludeAppPackagesFromCleanup.map(value => value),
        rebootAfterUse.map(value => value)
      )
    def arn: AmazonResourceName
    def name: Optional[Name]
    def description: Optional[Message]
    def packageCleanup: Optional[Boolean]
    def excludeAppPackagesFromCleanup: Optional[List[String]]
    def rebootAfterUse: Optional[Boolean]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getPackageCleanup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("packageCleanup", packageCleanup)
    def getExcludeAppPackagesFromCleanup: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "excludeAppPackagesFromCleanup",
        excludeAppPackagesFromCleanup
      )
    def getRebootAfterUse: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rebootAfterUse", rebootAfterUse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest
  ) extends zio.aws.devicefarm.model.UpdateInstanceProfileRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val packageCleanup: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.packageCleanup())
      .map(value => value: Boolean)
    override val excludeAppPackagesFromCleanup: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeAppPackagesFromCleanup())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val rebootAfterUse: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.rebootAfterUse())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest
  ): zio.aws.devicefarm.model.UpdateInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
