package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkProfileResponse(
    networkProfile: Optional[zio.aws.devicefarm.model.NetworkProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse = {
    import UpdateNetworkProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse
      .builder()
      .optionallyWith(networkProfile.map(value => value.buildAwsValue()))(
        _.networkProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly =
    zio.aws.devicefarm.model.UpdateNetworkProfileResponse.wrap(buildAwsValue())
}
object UpdateNetworkProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateNetworkProfileResponse =
      zio.aws.devicefarm.model.UpdateNetworkProfileResponse(
        networkProfile.map(value => value.asEditable)
      )
    def networkProfile
        : Optional[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]
    def getNetworkProfile
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      AwsError.unwrapOptionField("networkProfile", networkProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse
  ) extends zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly {
    override val networkProfile
        : Optional[zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProfile())
        .map(value => zio.aws.devicefarm.model.NetworkProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse
  ): zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly =
    new Wrapper(impl)
}
