package zio.aws.devicefarm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  JobTimeoutMinutes,
  Name,
  AmazonResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateProjectRequest(
    arn: AmazonResourceName,
    name: Optional[Name] = Optional.Absent,
    defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        defaultJobTimeoutMinutes.map(value =>
          JobTimeoutMinutes.unwrap(value): Integer
        )
      )(_.defaultJobTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UpdateProjectRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateProjectRequest =
      zio.aws.devicefarm.model.UpdateProjectRequest(
        arn,
        name.map(value => value),
        defaultJobTimeoutMinutes.map(value => value)
      )
    def arn: AmazonResourceName
    def name: Optional[Name]
    def defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField(
        "defaultJobTimeoutMinutes",
        defaultJobTimeoutMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest
  ) extends zio.aws.devicefarm.model.UpdateProjectRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultJobTimeoutMinutes())
        .map(value =>
          zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest
  ): zio.aws.devicefarm.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
