package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTestGridProjectResponse(
    testGridProject: Optional[zio.aws.devicefarm.model.TestGridProject] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectResponse = {
    import UpdateTestGridProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectResponse
      .builder()
      .optionallyWith(testGridProject.map(value => value.buildAwsValue()))(
        _.testGridProject
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateTestGridProjectResponse.ReadOnly =
    zio.aws.devicefarm.model.UpdateTestGridProjectResponse.wrap(buildAwsValue())
}
object UpdateTestGridProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateTestGridProjectResponse =
      zio.aws.devicefarm.model.UpdateTestGridProjectResponse(
        testGridProject.map(value => value.asEditable)
      )
    def testGridProject
        : Optional[zio.aws.devicefarm.model.TestGridProject.ReadOnly]
    def getTestGridProject: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridProject.ReadOnly
    ] = AwsError.unwrapOptionField("testGridProject", testGridProject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectResponse
  ) extends zio.aws.devicefarm.model.UpdateTestGridProjectResponse.ReadOnly {
    override val testGridProject
        : Optional[zio.aws.devicefarm.model.TestGridProject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testGridProject())
        .map(value => zio.aws.devicefarm.model.TestGridProject.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectResponse
  ): zio.aws.devicefarm.model.UpdateTestGridProjectResponse.ReadOnly =
    new Wrapper(impl)
}
