package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ContentType,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateUploadRequest(
    arn: AmazonResourceName,
    name: Optional[Name] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    editContent: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest = {
    import UpdateUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(editContent.map(value => value: java.lang.Boolean))(
        _.editContent
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UpdateUploadRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateUploadRequest.wrap(buildAwsValue())
}
object UpdateUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateUploadRequest =
      zio.aws.devicefarm.model.UpdateUploadRequest(
        arn,
        name.map(value => value),
        contentType.map(value => value),
        editContent.map(value => value)
      )
    def arn: AmazonResourceName
    def name: Optional[Name]
    def contentType: Optional[ContentType]
    def editContent: Optional[Boolean]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getEditContent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("editContent", editContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest
  ) extends zio.aws.devicefarm.model.UpdateUploadRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.devicefarm.model.primitives.ContentType(value))
    override val editContent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.editContent())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest
  ): zio.aws.devicefarm.model.UpdateUploadRequest.ReadOnly = new Wrapper(impl)
}
