package zio.aws.devicefarm
import zio.prelude.Subtype
import zio.aws.devicefarm.model.primitives.{
  OfferingIdentifier,
  Integer,
  AmazonResourceName,
  NonEmptyString,
  TagKey
}
import java.time.Instant
import zio.aws.devicefarm.model.primitives.PercentInteger.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AWSAccountNumber extends Subtype[String]
    type AWSAccountNumber =
      zio.aws.devicefarm.model.primitives.AWSAccountNumber.Type
    object AccountsCleanup extends Subtype[Boolean]
    type AccountsCleanup =
      zio.aws.devicefarm.model.primitives.AccountsCleanup.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName.Type
    object AppPackagesCleanup extends Subtype[Boolean]
    type AppPackagesCleanup =
      zio.aws.devicefarm.model.primitives.AppPackagesCleanup.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.devicefarm.model.primitives.ClientId.Type
    object ContentType extends Subtype[String]
    type ContentType = zio.aws.devicefarm.model.primitives.ContentType.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.devicefarm.model.primitives.DateTime.Type
    object DeviceFarmArn extends Subtype[String]
    type DeviceFarmArn = zio.aws.devicefarm.model.primitives.DeviceFarmArn.Type
    object Filter extends Subtype[String]
    type Filter = zio.aws.devicefarm.model.primitives.Filter.Type
    object HostAddress extends Subtype[String]
    type HostAddress = zio.aws.devicefarm.model.primitives.HostAddress.Type
    type Integer = Int
    object JobTimeoutMinutes extends Subtype[Int]
    type JobTimeoutMinutes =
      zio.aws.devicefarm.model.primitives.JobTimeoutMinutes.Type
    object MaxPageSize extends Subtype[Int]
    type MaxPageSize = zio.aws.devicefarm.model.primitives.MaxPageSize.Type
    object Message extends Subtype[String]
    type Message = zio.aws.devicefarm.model.primitives.Message.Type
    object Metadata extends Subtype[String]
    type Metadata = zio.aws.devicefarm.model.primitives.Metadata.Type
    object Name extends Subtype[String]
    type Name = zio.aws.devicefarm.model.primitives.Name.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.devicefarm.model.primitives.NonEmptyString.Type
    object OfferingIdentifier extends Subtype[String]
    type OfferingIdentifier =
      zio.aws.devicefarm.model.primitives.OfferingIdentifier.Type
    object OfferingPromotionIdentifier extends Subtype[String]
    type OfferingPromotionIdentifier =
      zio.aws.devicefarm.model.primitives.OfferingPromotionIdentifier.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.devicefarm.model.primitives.PaginationToken.Type
    object PercentInteger extends Subtype[Int]
    type PercentInteger =
      zio.aws.devicefarm.model.primitives.PercentInteger.Type
    object ResourceDescription extends Subtype[String]
    type ResourceDescription =
      zio.aws.devicefarm.model.primitives.ResourceDescription.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.devicefarm.model.primitives.ResourceId.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.devicefarm.model.primitives.ResourceName.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString =
      zio.aws.devicefarm.model.primitives.SensitiveString.Type
    object SensitiveURL extends Subtype[String]
    type SensitiveURL = zio.aws.devicefarm.model.primitives.SensitiveURL.Type
    object ServiceDnsName extends Subtype[String]
    type ServiceDnsName =
      zio.aws.devicefarm.model.primitives.ServiceDnsName.Type
    object SkipAppResign extends Subtype[Boolean]
    type SkipAppResign = zio.aws.devicefarm.model.primitives.SkipAppResign.Type
    object SshPublicKey extends Subtype[String]
    type SshPublicKey = zio.aws.devicefarm.model.primitives.SshPublicKey.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.devicefarm.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.devicefarm.model.primitives.TagValue.Type
    object TestGridUrlExpiresInSecondsInput extends Subtype[Int]
    type TestGridUrlExpiresInSecondsInput =
      zio.aws.devicefarm.model.primitives.TestGridUrlExpiresInSecondsInput.Type
    object TransactionIdentifier extends Subtype[String]
    type TransactionIdentifier =
      zio.aws.devicefarm.model.primitives.TransactionIdentifier.Type
    object URL extends Subtype[String]
    type URL = zio.aws.devicefarm.model.primitives.URL.Type
    object VPCEConfigurationDescription extends Subtype[String]
    type VPCEConfigurationDescription =
      zio.aws.devicefarm.model.primitives.VPCEConfigurationDescription.Type
    object VPCEConfigurationName extends Subtype[String]
    type VPCEConfigurationName =
      zio.aws.devicefarm.model.primitives.VPCEConfigurationName.Type
    object VPCEServiceName extends Subtype[String]
    type VPCEServiceName =
      zio.aws.devicefarm.model.primitives.VPCEServiceName.Type
    object VideoCapture extends Subtype[Boolean]
    type VideoCapture = zio.aws.devicefarm.model.primitives.VideoCapture.Type
  }
  type AmazonResourceNames = List[AmazonResourceName]
  type AndroidPaths = List[String]
  type Artifacts = List[zio.aws.devicefarm.model.Artifact]
  type DeviceFilterValues = List[String]
  type DeviceFilters = List[zio.aws.devicefarm.model.DeviceFilter]
  type DeviceHostPaths = List[String]
  type DeviceInstances = List[zio.aws.devicefarm.model.DeviceInstance]
  type DevicePoolCompatibilityResults =
    List[zio.aws.devicefarm.model.DevicePoolCompatibilityResult]
  type DevicePools = List[zio.aws.devicefarm.model.DevicePool]
  type Devices = List[zio.aws.devicefarm.model.Device]
  type IncompatibilityMessages =
    List[zio.aws.devicefarm.model.IncompatibilityMessage]
  type InstanceLabels = List[String]
  type InstanceProfiles = List[zio.aws.devicefarm.model.InstanceProfile]
  type IosPaths = List[String]
  type Jobs = List[zio.aws.devicefarm.model.Job]
  type MaxSlotMap = Map[String, Integer]
  type NetworkProfiles = List[zio.aws.devicefarm.model.NetworkProfile]
  type OfferingPromotions = List[zio.aws.devicefarm.model.OfferingPromotion]
  type OfferingStatusMap =
    Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus]
  type OfferingTransactions = List[zio.aws.devicefarm.model.OfferingTransaction]
  type Offerings = List[zio.aws.devicefarm.model.Offering]
  type PackageIds = List[String]
  type Problems = List[zio.aws.devicefarm.model.Problem]
  type Projects = List[zio.aws.devicefarm.model.Project]
  type PurchasedDevicesMap =
    Map[zio.aws.devicefarm.model.DevicePlatform, Integer]
  type RecurringCharges = List[zio.aws.devicefarm.model.RecurringCharge]
  type RemoteAccessSessions = List[zio.aws.devicefarm.model.RemoteAccessSession]
  type Rules = List[zio.aws.devicefarm.model.Rule]
  type Runs = List[zio.aws.devicefarm.model.Run]
  type Samples = List[zio.aws.devicefarm.model.Sample]
  type SecurityGroupIds = List[NonEmptyString]
  type SubnetIds = List[NonEmptyString]
  type Suites = List[zio.aws.devicefarm.model.Suite]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.devicefarm.model.Tag]
  type TestGridProjects = List[zio.aws.devicefarm.model.TestGridProject]
  type TestGridSessionActions =
    List[zio.aws.devicefarm.model.TestGridSessionAction]
  type TestGridSessionArtifacts =
    List[zio.aws.devicefarm.model.TestGridSessionArtifact]
  type TestGridSessions = List[zio.aws.devicefarm.model.TestGridSession]
  type TestParameters = Map[String, String]
  type Tests = List[zio.aws.devicefarm.model.Test]
  type UniqueProblems = List[zio.aws.devicefarm.model.UniqueProblem]
  type UniqueProblemsByExecutionResultMap =
    Map[zio.aws.devicefarm.model.ExecutionResult, Iterable[
      zio.aws.devicefarm.model.UniqueProblem
    ]]
  type Uploads = List[zio.aws.devicefarm.model.Upload]
  type VPCEConfigurations = List[zio.aws.devicefarm.model.VPCEConfiguration]
}
