package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Counters(
    total: Optional[Integer] = Optional.Absent,
    passed: Optional[Integer] = Optional.Absent,
    failed: Optional[Integer] = Optional.Absent,
    warned: Optional[Integer] = Optional.Absent,
    errored: Optional[Integer] = Optional.Absent,
    stopped: Optional[Integer] = Optional.Absent,
    skipped: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Counters = {
    import Counters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Counters
      .builder()
      .optionallyWith(total.map(value => value: java.lang.Integer))(_.total)
      .optionallyWith(passed.map(value => value: java.lang.Integer))(_.passed)
      .optionallyWith(failed.map(value => value: java.lang.Integer))(_.failed)
      .optionallyWith(warned.map(value => value: java.lang.Integer))(_.warned)
      .optionallyWith(errored.map(value => value: java.lang.Integer))(_.errored)
      .optionallyWith(stopped.map(value => value: java.lang.Integer))(_.stopped)
      .optionallyWith(skipped.map(value => value: java.lang.Integer))(_.skipped)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Counters.ReadOnly =
    zio.aws.devicefarm.model.Counters.wrap(buildAwsValue())
}
object Counters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Counters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Counters =
      zio.aws.devicefarm.model.Counters(
        total.map(value => value),
        passed.map(value => value),
        failed.map(value => value),
        warned.map(value => value),
        errored.map(value => value),
        stopped.map(value => value),
        skipped.map(value => value)
      )
    def total: Optional[Integer]
    def passed: Optional[Integer]
    def failed: Optional[Integer]
    def warned: Optional[Integer]
    def errored: Optional[Integer]
    def stopped: Optional[Integer]
    def skipped: Optional[Integer]
    def getTotal: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("total", total)
    def getPassed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("passed", passed)
    def getFailed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failed", failed)
    def getWarned: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("warned", warned)
    def getErrored: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("errored", errored)
    def getStopped: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getSkipped: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("skipped", skipped)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Counters
  ) extends zio.aws.devicefarm.model.Counters.ReadOnly {
    override val total: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: Integer)
    override val passed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.passed())
      .map(value => value: Integer)
    override val failed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value => value: Integer)
    override val warned: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.warned())
      .map(value => value: Integer)
    override val errored: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.errored())
      .map(value => value: Integer)
    override val stopped: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.stopped())
      .map(value => value: Integer)
    override val skipped: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.skipped())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Counters
  ): zio.aws.devicefarm.model.Counters.ReadOnly = new Wrapper(impl)
}
