package zio.aws.devicefarm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  PercentInteger,
  Message,
  Name,
  AmazonResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateNetworkProfileRequest(
    projectArn: AmazonResourceName,
    name: Name,
    description: Optional[Message] = Optional.Absent,
    `type`: Optional[zio.aws.devicefarm.model.NetworkProfileType] =
      Optional.Absent,
    uplinkBandwidthBits: Optional[Long] = Optional.Absent,
    downlinkBandwidthBits: Optional[Long] = Optional.Absent,
    uplinkDelayMs: Optional[Long] = Optional.Absent,
    downlinkDelayMs: Optional[Long] = Optional.Absent,
    uplinkJitterMs: Optional[Long] = Optional.Absent,
    downlinkJitterMs: Optional[Long] = Optional.Absent,
    uplinkLossPercent: Optional[PercentInteger] = Optional.Absent,
    downlinkLossPercent: Optional[PercentInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest = {
    import CreateNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest
      .builder()
      .projectArn(AmazonResourceName.unwrap(projectArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(uplinkBandwidthBits.map(value => value: java.lang.Long))(
        _.uplinkBandwidthBits
      )
      .optionallyWith(
        downlinkBandwidthBits.map(value => value: java.lang.Long)
      )(_.downlinkBandwidthBits)
      .optionallyWith(uplinkDelayMs.map(value => value: java.lang.Long))(
        _.uplinkDelayMs
      )
      .optionallyWith(downlinkDelayMs.map(value => value: java.lang.Long))(
        _.downlinkDelayMs
      )
      .optionallyWith(uplinkJitterMs.map(value => value: java.lang.Long))(
        _.uplinkJitterMs
      )
      .optionallyWith(downlinkJitterMs.map(value => value: java.lang.Long))(
        _.downlinkJitterMs
      )
      .optionallyWith(
        uplinkLossPercent.map(value => PercentInteger.unwrap(value): Integer)
      )(_.uplinkLossPercent)
      .optionallyWith(
        downlinkLossPercent.map(value => PercentInteger.unwrap(value): Integer)
      )(_.downlinkLossPercent)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateNetworkProfileRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateNetworkProfileRequest.wrap(buildAwsValue())
}
object CreateNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateNetworkProfileRequest =
      zio.aws.devicefarm.model.CreateNetworkProfileRequest(
        projectArn,
        name,
        description.map(value => value),
        `type`.map(value => value),
        uplinkBandwidthBits.map(value => value),
        downlinkBandwidthBits.map(value => value),
        uplinkDelayMs.map(value => value),
        downlinkDelayMs.map(value => value),
        uplinkJitterMs.map(value => value),
        downlinkJitterMs.map(value => value),
        uplinkLossPercent.map(value => value),
        downlinkLossPercent.map(value => value)
      )
    def projectArn: AmazonResourceName
    def name: Name
    def description: Optional[Message]
    def `type`: Optional[zio.aws.devicefarm.model.NetworkProfileType]
    def uplinkBandwidthBits: Optional[Long]
    def downlinkBandwidthBits: Optional[Long]
    def uplinkDelayMs: Optional[Long]
    def downlinkDelayMs: Optional[Long]
    def uplinkJitterMs: Optional[Long]
    def downlinkJitterMs: Optional[Long]
    def uplinkLossPercent: Optional[PercentInteger]
    def downlinkLossPercent: Optional[PercentInteger]
    def getProjectArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(projectArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getType
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfileType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUplinkBandwidthBits: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkBandwidthBits", uplinkBandwidthBits)
    def getDownlinkBandwidthBits: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkBandwidthBits", downlinkBandwidthBits)
    def getUplinkDelayMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkDelayMs", uplinkDelayMs)
    def getDownlinkDelayMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkDelayMs", downlinkDelayMs)
    def getUplinkJitterMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkJitterMs", uplinkJitterMs)
    def getDownlinkJitterMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkJitterMs", downlinkJitterMs)
    def getUplinkLossPercent: ZIO[Any, AwsError, PercentInteger] =
      AwsError.unwrapOptionField("uplinkLossPercent", uplinkLossPercent)
    def getDownlinkLossPercent: ZIO[Any, AwsError, PercentInteger] =
      AwsError.unwrapOptionField("downlinkLossPercent", downlinkLossPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest
  ) extends zio.aws.devicefarm.model.CreateNetworkProfileRequest.ReadOnly {
    override val projectArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.projectArn())
    override val name: Name =
      zio.aws.devicefarm.model.primitives.Name(impl.name())
    override val description: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val `type`: Optional[zio.aws.devicefarm.model.NetworkProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devicefarm.model.NetworkProfileType.wrap(value))
    override val uplinkBandwidthBits: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.uplinkBandwidthBits())
      .map(value => value: Long)
    override val downlinkBandwidthBits: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.downlinkBandwidthBits())
      .map(value => value: Long)
    override val uplinkDelayMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.uplinkDelayMs())
      .map(value => value: Long)
    override val downlinkDelayMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.downlinkDelayMs())
      .map(value => value: Long)
    override val uplinkJitterMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.uplinkJitterMs())
      .map(value => value: Long)
    override val downlinkJitterMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.downlinkJitterMs())
      .map(value => value: Long)
    override val uplinkLossPercent: Optional[PercentInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uplinkLossPercent())
        .map(value => zio.aws.devicefarm.model.primitives.PercentInteger(value))
    override val downlinkLossPercent: Optional[PercentInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downlinkLossPercent())
        .map(value => zio.aws.devicefarm.model.primitives.PercentInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest
  ): zio.aws.devicefarm.model.CreateNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
