package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{ResourceDescription, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTestGridProjectRequest(
    name: ResourceName,
    description: Optional[ResourceDescription] = Optional.Absent,
    vpcConfig: Optional[zio.aws.devicefarm.model.TestGridVpcConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest = {
    import CreateTestGridProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateTestGridProjectRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateTestGridProjectRequest.wrap(buildAwsValue())
}
object CreateTestGridProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateTestGridProjectRequest =
      zio.aws.devicefarm.model.CreateTestGridProjectRequest(
        name,
        description.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def name: ResourceName
    def description: Optional[ResourceDescription]
    def vpcConfig: Optional[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest
  ) extends zio.aws.devicefarm.model.CreateTestGridProjectRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.devicefarm.model.primitives.ResourceName(impl.name())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.devicefarm.model.primitives.ResourceDescription(value)
        )
    override val vpcConfig
        : Optional[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.devicefarm.model.TestGridVpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest
  ): zio.aws.devicefarm.model.CreateTestGridProjectRequest.ReadOnly =
    new Wrapper(impl)
}
