package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteInstanceProfileRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest = {
    import DeleteInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.DeleteInstanceProfileRequest.ReadOnly =
    zio.aws.devicefarm.model.DeleteInstanceProfileRequest.wrap(buildAwsValue())
}
object DeleteInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeleteInstanceProfileRequest =
      zio.aws.devicefarm.model.DeleteInstanceProfileRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest
  ) extends zio.aws.devicefarm.model.DeleteInstanceProfileRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest
  ): zio.aws.devicefarm.model.DeleteInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
