package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRemoteAccessSessionRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest = {
    import DeleteRemoteAccessSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest.ReadOnly =
    zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest
      .wrap(buildAwsValue())
}
object DeleteRemoteAccessSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest =
      zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest
  ) extends zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest
  ): zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest.ReadOnly =
    new Wrapper(impl)
}
