package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Device(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    manufacturer: Optional[String] = Optional.Absent,
    model: Optional[String] = Optional.Absent,
    modelId: Optional[String] = Optional.Absent,
    formFactor: Optional[zio.aws.devicefarm.model.DeviceFormFactor] =
      Optional.Absent,
    platform: Optional[zio.aws.devicefarm.model.DevicePlatform] =
      Optional.Absent,
    os: Optional[String] = Optional.Absent,
    cpu: Optional[zio.aws.devicefarm.model.CPU] = Optional.Absent,
    resolution: Optional[zio.aws.devicefarm.model.Resolution] = Optional.Absent,
    heapSize: Optional[Long] = Optional.Absent,
    memory: Optional[Long] = Optional.Absent,
    image: Optional[String] = Optional.Absent,
    carrier: Optional[String] = Optional.Absent,
    radio: Optional[String] = Optional.Absent,
    remoteAccessEnabled: Optional[Boolean] = Optional.Absent,
    remoteDebugEnabled: Optional[Boolean] = Optional.Absent,
    fleetType: Optional[String] = Optional.Absent,
    fleetName: Optional[String] = Optional.Absent,
    instances: Optional[Iterable[zio.aws.devicefarm.model.DeviceInstance]] =
      Optional.Absent,
    availability: Optional[zio.aws.devicefarm.model.DeviceAvailability] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Device
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(manufacturer.map(value => value: java.lang.String))(
        _.manufacturer
      )
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(modelId.map(value => value: java.lang.String))(_.modelId)
      .optionallyWith(formFactor.map(value => value.unwrap))(_.formFactor)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(os.map(value => value: java.lang.String))(_.os)
      .optionallyWith(cpu.map(value => value.buildAwsValue()))(_.cpu)
      .optionallyWith(resolution.map(value => value.buildAwsValue()))(
        _.resolution
      )
      .optionallyWith(heapSize.map(value => value: java.lang.Long))(_.heapSize)
      .optionallyWith(memory.map(value => value: java.lang.Long))(_.memory)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(carrier.map(value => value: java.lang.String))(_.carrier)
      .optionallyWith(radio.map(value => value: java.lang.String))(_.radio)
      .optionallyWith(
        remoteAccessEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteAccessEnabled)
      .optionallyWith(
        remoteDebugEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteDebugEnabled)
      .optionallyWith(fleetType.map(value => value: java.lang.String))(
        _.fleetType
      )
      .optionallyWith(fleetName.map(value => value: java.lang.String))(
        _.fleetName
      )
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(availability.map(value => value.unwrap))(_.availability)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Device.ReadOnly =
    zio.aws.devicefarm.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Device] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Device =
      zio.aws.devicefarm.model.Device(
        arn.map(value => value),
        name.map(value => value),
        manufacturer.map(value => value),
        model.map(value => value),
        modelId.map(value => value),
        formFactor.map(value => value),
        platform.map(value => value),
        os.map(value => value),
        cpu.map(value => value.asEditable),
        resolution.map(value => value.asEditable),
        heapSize.map(value => value),
        memory.map(value => value),
        image.map(value => value),
        carrier.map(value => value),
        radio.map(value => value),
        remoteAccessEnabled.map(value => value),
        remoteDebugEnabled.map(value => value),
        fleetType.map(value => value),
        fleetName.map(value => value),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availability.map(value => value)
      )
    def arn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def manufacturer: Optional[String]
    def model: Optional[String]
    def modelId: Optional[String]
    def formFactor: Optional[zio.aws.devicefarm.model.DeviceFormFactor]
    def platform: Optional[zio.aws.devicefarm.model.DevicePlatform]
    def os: Optional[String]
    def cpu: Optional[zio.aws.devicefarm.model.CPU.ReadOnly]
    def resolution: Optional[zio.aws.devicefarm.model.Resolution.ReadOnly]
    def heapSize: Optional[Long]
    def memory: Optional[Long]
    def image: Optional[String]
    def carrier: Optional[String]
    def radio: Optional[String]
    def remoteAccessEnabled: Optional[Boolean]
    def remoteDebugEnabled: Optional[Boolean]
    def fleetType: Optional[String]
    def fleetName: Optional[String]
    def instances
        : Optional[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]]
    def availability: Optional[zio.aws.devicefarm.model.DeviceAvailability]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getManufacturer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("manufacturer", manufacturer)
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getModelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelId", modelId)
    def getFormFactor
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceFormFactor] =
      AwsError.unwrapOptionField("formFactor", formFactor)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOs: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("os", os)
    def getCpu: ZIO[Any, AwsError, zio.aws.devicefarm.model.CPU.ReadOnly] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getResolution
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Resolution.ReadOnly] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getHeapSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("heapSize", heapSize)
    def getMemory: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("memory", memory)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getCarrier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrier", carrier)
    def getRadio: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("radio", radio)
    def getRemoteAccessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteAccessEnabled", remoteAccessEnabled)
    def getRemoteDebugEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteDebugEnabled", remoteDebugEnabled)
    def getFleetType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getFleetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fleetName", fleetName)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DeviceInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getAvailability
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceAvailability] =
      AwsError.unwrapOptionField("availability", availability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Device
  ) extends zio.aws.devicefarm.model.Device.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val manufacturer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.manufacturer())
      .map(value => value: String)
    override val model: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => value: String)
    override val modelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modelId())
      .map(value => value: String)
    override val formFactor
        : Optional[zio.aws.devicefarm.model.DeviceFormFactor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formFactor())
        .map(value => zio.aws.devicefarm.model.DeviceFormFactor.wrap(value))
    override val platform: Optional[zio.aws.devicefarm.model.DevicePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.devicefarm.model.DevicePlatform.wrap(value))
    override val os: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.os())
      .map(value => value: String)
    override val cpu: Optional[zio.aws.devicefarm.model.CPU.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpu())
        .map(value => zio.aws.devicefarm.model.CPU.wrap(value))
    override val resolution
        : Optional[zio.aws.devicefarm.model.Resolution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolution())
        .map(value => zio.aws.devicefarm.model.Resolution.wrap(value))
    override val heapSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.heapSize())
      .map(value => value: Long)
    override val memory: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: Long)
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val carrier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.carrier())
      .map(value => value: String)
    override val radio: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.radio())
      .map(value => value: String)
    override val remoteAccessEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteAccessEnabled())
      .map(value => value: Boolean)
    override val remoteDebugEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteDebugEnabled())
      .map(value => value: Boolean)
    override val fleetType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetType())
      .map(value => value: String)
    override val fleetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetName())
      .map(value => value: String)
    override val instances
        : Optional[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.DeviceInstance.wrap(item)
          }.toList
        )
    override val availability
        : Optional[zio.aws.devicefarm.model.DeviceAvailability] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availability())
        .map(value => zio.aws.devicefarm.model.DeviceAvailability.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Device
  ): zio.aws.devicefarm.model.Device.ReadOnly = new Wrapper(impl)
}
