package zio.aws.devicefarm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  AccountsCleanup,
  JobTimeoutMinutes,
  VideoCapture,
  SkipAppResign,
  AppPackagesCleanup
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ExecutionConfiguration(
    jobTimeoutMinutes: Optional[JobTimeoutMinutes] = Optional.Absent,
    accountsCleanup: Optional[AccountsCleanup] = Optional.Absent,
    appPackagesCleanup: Optional[AppPackagesCleanup] = Optional.Absent,
    videoCapture: Optional[VideoCapture] = Optional.Absent,
    skipAppResign: Optional[SkipAppResign] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration = {
    import ExecutionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration
      .builder()
      .optionallyWith(
        jobTimeoutMinutes.map(value => JobTimeoutMinutes.unwrap(value): Integer)
      )(_.jobTimeoutMinutes)
      .optionallyWith(
        accountsCleanup.map(value =>
          AccountsCleanup.unwrap(value): java.lang.Boolean
        )
      )(_.accountsCleanup)
      .optionallyWith(
        appPackagesCleanup.map(value =>
          AppPackagesCleanup.unwrap(value): java.lang.Boolean
        )
      )(_.appPackagesCleanup)
      .optionallyWith(
        videoCapture.map(value => VideoCapture.unwrap(value): java.lang.Boolean)
      )(_.videoCapture)
      .optionallyWith(
        skipAppResign.map(value =>
          SkipAppResign.unwrap(value): java.lang.Boolean
        )
      )(_.skipAppResign)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ExecutionConfiguration.ReadOnly =
    zio.aws.devicefarm.model.ExecutionConfiguration.wrap(buildAwsValue())
}
object ExecutionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ExecutionConfiguration =
      zio.aws.devicefarm.model.ExecutionConfiguration(
        jobTimeoutMinutes.map(value => value),
        accountsCleanup.map(value => value),
        appPackagesCleanup.map(value => value),
        videoCapture.map(value => value),
        skipAppResign.map(value => value)
      )
    def jobTimeoutMinutes: Optional[JobTimeoutMinutes]
    def accountsCleanup: Optional[AccountsCleanup]
    def appPackagesCleanup: Optional[AppPackagesCleanup]
    def videoCapture: Optional[VideoCapture]
    def skipAppResign: Optional[SkipAppResign]
    def getJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField("jobTimeoutMinutes", jobTimeoutMinutes)
    def getAccountsCleanup: ZIO[Any, AwsError, AccountsCleanup] =
      AwsError.unwrapOptionField("accountsCleanup", accountsCleanup)
    def getAppPackagesCleanup: ZIO[Any, AwsError, AppPackagesCleanup] =
      AwsError.unwrapOptionField("appPackagesCleanup", appPackagesCleanup)
    def getVideoCapture: ZIO[Any, AwsError, VideoCapture] =
      AwsError.unwrapOptionField("videoCapture", videoCapture)
    def getSkipAppResign: ZIO[Any, AwsError, SkipAppResign] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration
  ) extends zio.aws.devicefarm.model.ExecutionConfiguration.ReadOnly {
    override val jobTimeoutMinutes: Optional[JobTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTimeoutMinutes())
        .map(value =>
          zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
        )
    override val accountsCleanup: Optional[AccountsCleanup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountsCleanup())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AccountsCleanup(value)
        )
    override val appPackagesCleanup: Optional[AppPackagesCleanup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appPackagesCleanup())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AppPackagesCleanup(value)
        )
    override val videoCapture: Optional[VideoCapture] = zio.aws.core.internal
      .optionalFromNullable(impl.videoCapture())
      .map(value => zio.aws.devicefarm.model.primitives.VideoCapture(value))
    override val skipAppResign: Optional[SkipAppResign] = zio.aws.core.internal
      .optionalFromNullable(impl.skipAppResign())
      .map(value => zio.aws.devicefarm.model.primitives.SkipAppResign(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration
  ): zio.aws.devicefarm.model.ExecutionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
