package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetProjectResponse(
    project: Optional[zio.aws.devicefarm.model.Project] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetProjectResponse = {
    import GetProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetProjectResponse
      .builder()
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetProjectResponse.ReadOnly =
    zio.aws.devicefarm.model.GetProjectResponse.wrap(buildAwsValue())
}
object GetProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetProjectResponse =
      zio.aws.devicefarm.model
        .GetProjectResponse(project.map(value => value.asEditable))
    def project: Optional[zio.aws.devicefarm.model.Project.ReadOnly]
    def getProject
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Project.ReadOnly] =
      AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetProjectResponse
  ) extends zio.aws.devicefarm.model.GetProjectResponse.ReadOnly {
    override val project: Optional[zio.aws.devicefarm.model.Project.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.project())
        .map(value => zio.aws.devicefarm.model.Project.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetProjectResponse
  ): zio.aws.devicefarm.model.GetProjectResponse.ReadOnly = new Wrapper(impl)
}
