package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRemoteAccessSessionResponse(
    remoteAccessSession: Optional[
      zio.aws.devicefarm.model.RemoteAccessSession
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse = {
    import GetRemoteAccessSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse
      .builder()
      .optionallyWith(remoteAccessSession.map(value => value.buildAwsValue()))(
        _.remoteAccessSession
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly =
    zio.aws.devicefarm.model.GetRemoteAccessSessionResponse
      .wrap(buildAwsValue())
}
object GetRemoteAccessSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetRemoteAccessSessionResponse =
      zio.aws.devicefarm.model.GetRemoteAccessSessionResponse(
        remoteAccessSession.map(value => value.asEditable)
      )
    def remoteAccessSession
        : Optional[zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly]
    def getRemoteAccessSession: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly
    ] = AwsError.unwrapOptionField("remoteAccessSession", remoteAccessSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse
  ) extends zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly {
    override val remoteAccessSession
        : Optional[zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccessSession())
        .map(value => zio.aws.devicefarm.model.RemoteAccessSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse
  ): zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly =
    new Wrapper(impl)
}
