package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRunRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetRunRequest = {
    import GetRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetRunRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetRunRequest.ReadOnly =
    zio.aws.devicefarm.model.GetRunRequest.wrap(buildAwsValue())
}
object GetRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetRunRequest =
      zio.aws.devicefarm.model.GetRunRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRunRequest
  ) extends zio.aws.devicefarm.model.GetRunRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetRunRequest
  ): zio.aws.devicefarm.model.GetRunRequest.ReadOnly = new Wrapper(impl)
}
